unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls,
  MyXML, ComCtrls;


type
  TMainForm = class(TForm)
    OpenDialog: TOpenDialog;
    Panel1: TPanel;
    btnPUSTY_PLIK: TBitBtn;
    btnWCZYTAJ: TBitBtn;
    btnADD_ADRES: TBitBtn;
    btnODCZYTAJ: TBitBtn;
    btnADD_DZIECI: TBitBtn;
    btnSPR_SEKCJE: TBitBtn;
    btnUSUN_SEKCJE: TBitBtn;
    btnCLOSE: TBitBtn;
    Memo: TMemo;
    procedure btnODCZYTAJClick(Sender: TObject);
    procedure btnADD_DZIECIClick(Sender: TObject);
    procedure btnADD_ADRESClick(Sender: TObject);
    procedure btnWCZYTAJClick(Sender: TObject);
    procedure btnPUSTY_PLIKClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure btnCLOSEClick(Sender: TObject);
    procedure btnSPR_SEKCJEClick(Sender: TObject);
    procedure btnUSUN_SEKCJEClick(Sender: TObject);

  private
	 procedure Wczytaj();
	 procedure Czytanie(fn : String);


  public
   fn : String;

  end;

var
  MainForm: TMainForm;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TMainForm.btnCLOSEClick(Sender: TObject);
begin
	Close();
end;

procedure TMainForm.btnPUSTY_PLIKClick(Sender: TObject);
var
   ini   : MXML;

begin
   fn := ExtractFilePath(Application.ExeName) + 'nowy.xml';

   if FileExists(fn) then
   begin
      DeleteFile(fn);
   end;

	try
	   ini := MXML.Create(fn);
   finally
	   FreeAndNil(ini);
   end;
   // poka zawarto w Memo
   Wczytaj();
end;

procedure TMainForm.FormShow(Sender: TObject);
begin
	Memo.Clear();
   Memo.Align := alClient;
end;

procedure TMainForm.btnWCZYTAJClick(Sender: TObject);

begin
   Memo.Lines.Clear();

   if OpenDialog.Execute() then
   begin
      if Pos('.xml', OpenDialog.FileName) > 0 then
   	begin
         fn := OpenDialog.FileName;

         if FileExists(fn) then
      	begin
			   Wczytaj();
         end;
      end;
   end;
end;

procedure TMainForm.btnADD_ADRESClick(Sender: TObject);
var
   ini : MXML;

begin
   Memo.Lines.Clear();

   fn := ExtractFilePath(Application.ExeName) + 'nowy.xml';

   if not FileExists(fn) then
	begin
		ShowMessage('Brak pliku: ' + fn);
   	exit;
   end;

	try
      ini := MXML.Create(fn);

		if not ini.SectionExist('adres') then
   	begin
         ini.AddSection('adres');

         ini.WriteString('adres', 'ulica' , '3 Maja 132');
         ini.WriteString('adres', 'miasto', 'Pszczyna');
         ini.WriteString('adres', 'kodp'  , '43-200');
      end;
   finally
		FreeAndNil(ini);
   end;

   Memo.Lines.Clear();
   Wczytaj();
   Memo.Visible := true;
end;

procedure TMainForm.btnADD_DZIECIClick(Sender: TObject);
var
   ini   : MXML;

begin
   Memo.Lines.Clear();

   fn := ExtractFileDir(Application.ExeName);
   fn := fn + '\' + 'nowy.xml';

   if not FileExists(fn) then
   begin
		ShowMessage('Brak pliku: ' + fn);
      exit;
   end;


	try
      ini := MXML.Create(fn);

      if not ini.SectionExist('dzieci') then
      begin
         ini.AddSection('dzieci');
         ini.WriteString('dzieci', 'syn'   , 'Piotr');
         ini.WriteString('dzieci', 'crka' , 'Marzena');
      end;
	finally
   	FreeAndNil(ini);
	end;

   Memo.Lines.Clear();
   Wczytaj();
   Memo.Visible := true;
end;

procedure TMainForm.btnODCZYTAJClick(Sender: TObject);
begin
   Memo.Lines.Clear();

   fn := ExtractFilePath(Application.ExeName) + 'nowy.xml';

   if FileExists(fn) then
   begin
      Czytanie(fn);
   end;
end;

procedure TMainForm.Czytanie(fn : String);
var
	Lista : TStringList;
   lp    : Integer;
   ini   : MXML;

begin
   Lista := TStringList.Create();

	try
      ini := MXML.Create(fn);
      ini.ReadSections(Lista);

      for lp := 0 to Lista.Count-1 do
      begin
         Memo.Lines.Add(Lista[lp]);
      end;
   finally
 		Lista.Clear();
      FreeAndNil(Lista);

	   FreeAndNil(ini);
   end;
end;

procedure TMainForm.btnSPR_SEKCJEClick(Sender: TObject);
var
	ini : MXML;

begin
   Memo.Lines.Clear();

   fn := ExtractFilePath(Application.ExeName) + 'nowy.xml';

   if not FileExists(fn) then
   begin
      Memo.Lines.Add('Brak pliku: ' + fn);
   	exit;
   end;

	try
      ini := MXML.Create(fn);

      if ini.SectionExist('adres') then
      begin
         Memo.Lines.Add('Sekcja adres istnieje');
      end
      else begin
         Memo.Lines.Add('Sekcja adres nie istnieje');
      end;

      if ini.SectionExist('dzieci') then
      begin
         Memo.Lines.Add('Sekcja dzieci istnieje');
      end
      else begin
         Memo.Lines.Add('Sekcja dzieci nie istnieje');
      end;

      if ini.SectionExist('zegar') then
      begin
         Memo.Lines.Add('Sekcja zegar istnieje');
      end
      else begin
         Memo.Lines.Add('Sekcja zegar nie istnieje');
      end;
   finally
   	FreeAndNil(ini);
   end;
end;

procedure TMainForm.btnUSUN_SEKCJEClick(Sender: TObject);
var
	ini : MXML;

begin
   Memo.Lines.Clear();

   fn := ExtractFilePath(Application.ExeName) + 'nowy.xml';

   if not FileExists(fn) then
   begin
		ShowMessage('Brak pliku: ' + fn);
   	exit;
   end;

	try
      ini := MXML.Create(fn);

      if ini.SectionExist('adres') then
      begin
         ShowMessage('Sekcja adres istnieje - zostanie usunita');
         ini.EraseSection('adres');
      end
      else begin
         ShowMessage('Sekcja adres nie istnieje');
      end;
	finally
   	FreeAndNil(ini);
	end;

   Wczytaj();
end;

procedure TMainForm.Wczytaj();
begin
   Memo.Clear();
	Memo.Lines.LoadFromFile(fn);
end;

end.

